/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.crafting;

import fr.iglee42.evolvedmekanism.EvolvedMekanism;
import fr.iglee42.evolvedmekanism.blocks.BlockTieredPersonnalBarrel;
import fr.iglee42.evolvedmekanism.inventory.personalstorage.TieredPersonalStorageManager;
import fr.iglee42.evolvedmekanism.items.ItemBlockTieredPersonalStorage;
import fr.iglee42.evolvedmekanism.registries.EMBlocks;
import fr.iglee42.evolvedmekanism.registries.EMRecipeSerializers;
import fr.iglee42.evolvedmekanism.tiers.PersonalStorageTier;
import java.util.Arrays;
import java.util.UUID;
import mekanism.common.block.BlockPersonalBarrel;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.item.block.ItemBlockPersonalStorage;
import mekanism.common.lib.inventory.personalstorage.AbstractPersonalStorageItemInventory;
import mekanism.common.lib.inventory.personalstorage.PersonalStorageManager;
import mekanism.common.registries.MekanismItems;
import mekanism.common.util.SecurityUtils;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;

public class PersonalBarrelUpgrading
extends CustomRecipe {
    public PersonalBarrelUpgrading(ResourceLocation p_248647_, CraftingBookCategory p_250756_) {
        super(p_248647_, p_250756_);
    }

    public boolean matches(CraftingContainer container, Level level) {
        Boolean[] isValid = new Boolean[9];
        if (container.m_6643_() > 9) {
            return false;
        }
        Item item = container.m_8020_(4).m_41720_();
        if (item instanceof ItemBlockPersonalStorage) {
            ItemBlockPersonalStorage it = (ItemBlockPersonalStorage)item;
            if (!(it.m_40614_() instanceof BlockPersonalBarrel)) {
                return false;
            }
            isValid[4] = true;
            for (int i = 0; i < container.m_6643_(); ++i) {
                if (i == 4) continue;
                if (i == 0 || i == 2 || i >= 6) {
                    isValid[i] = container.m_8020_(i).m_150930_(MekanismItems.STEEL_INGOT.m_5456_());
                }
                if (i == 1) {
                    isValid[i] = container.m_8020_(i).m_204117_(Tags.Items.GLASS_SILICA);
                }
                if (i != 3 && i != 5) continue;
                isValid[i] = container.m_8020_(i).m_150930_(MekanismItems.ADVANCED_CONTROL_CIRCUIT.m_5456_());
            }
            return Arrays.stream(isValid).allMatch(Boolean::booleanValue);
        }
        Item i = container.m_8020_(4).m_41720_();
        if (!(i instanceof ItemBlockTieredPersonalStorage)) {
            return false;
        }
        ItemBlockTieredPersonalStorage it = (ItemBlockTieredPersonalStorage)i;
        Block block = it.m_40614_();
        if (!(block instanceof BlockTieredPersonnalBarrel)) {
            return false;
        }
        BlockTieredPersonnalBarrel chest = (BlockTieredPersonnalBarrel)block;
        PersonalStorageTier tier = chest.getTier();
        if (BlockTieredPersonnalBarrel.getUpgrade(tier) == null) {
            return false;
        }
        if (tier.ordinal() >= PersonalStorageTier.values().length - 1) {
            return false;
        }
        PersonalStorageTier nextTier = PersonalStorageTier.values()[tier.ordinal() + 1];
        if (EvolvedMekanism.getCircuitByTier(nextTier.getBaseTier()) == null) {
            return false;
        }
        isValid[4] = true;
        for (int i2 = 0; i2 < container.m_6643_(); ++i2) {
            if (i2 == 4) continue;
            if (i2 == 0 || i2 == 2 || i2 >= 6) {
                isValid[i2] = container.m_8020_(i2).m_150930_(MekanismItems.STEEL_INGOT.m_5456_());
            }
            if (i2 == 1) {
                isValid[i2] = container.m_8020_(i2).m_204117_(Tags.Items.GLASS_SILICA);
            }
            if (i2 != 3 && i2 != 5) continue;
            isValid[i2] = container.m_8020_(i2).m_150930_(EvolvedMekanism.getCircuitByTier(nextTier.getBaseTier()).m_5456_());
        }
        return Arrays.stream(isValid).allMatch(Boolean::booleanValue);
    }

    @NotNull
    public ItemStack assemble(CraftingContainer container, RegistryAccess access) {
        Object owner;
        ItemStack oldBarrel = container.m_8020_(4);
        Item item = container.m_8020_(4).m_41720_();
        if (item instanceof ItemBlockPersonalStorage) {
            ItemBlockPersonalStorage it = (ItemBlockPersonalStorage)item;
            owner = SecurityUtils.get().getOwnerUUID((ICapabilityProvider)oldBarrel);
            if (owner == null) {
                return new ItemStack((ItemLike)EMBlocks.ADVANCED_PERSONAL_BARREL.m_5456_());
            }
            AbstractPersonalStorageItemInventory inventory = PersonalStorageManager.getInventoryFor((ItemStack)oldBarrel).orElse(null);
            if (inventory == null) {
                return new ItemStack((ItemLike)EMBlocks.ADVANCED_PERSONAL_BARREL.m_5456_());
            }
            ItemStack stack = new ItemStack((ItemLike)EMBlocks.ADVANCED_PERSONAL_BARREL.m_5456_());
            stack.getCapability(Capabilities.OWNER_OBJECT).ifPresent(i -> i.setOwnerUUID(SecurityUtils.get().getOwnerUUID((ICapabilityProvider)oldBarrel)));
            TieredPersonalStorageManager.transferFromBasic(inventory, stack);
            return stack;
        }
        owner = container.m_8020_(4).m_41720_();
        if (!(owner instanceof ItemBlockTieredPersonalStorage)) {
            return ItemStack.f_41583_;
        }
        ItemBlockTieredPersonalStorage it = (ItemBlockTieredPersonalStorage)((Object)owner);
        Block inventory = it.m_40614_();
        if (!(inventory instanceof BlockTieredPersonnalBarrel)) {
            return ItemStack.f_41583_;
        }
        BlockTieredPersonnalBarrel chest = (BlockTieredPersonnalBarrel)inventory;
        PersonalStorageTier tier = chest.getTier();
        if (BlockTieredPersonnalBarrel.getUpgrade(tier) == null) {
            return ItemStack.f_41583_;
        }
        if (tier.ordinal() >= PersonalStorageTier.values().length - 1) {
            return ItemStack.f_41583_;
        }
        UUID owner2 = SecurityUtils.get().getOwnerUUID((ICapabilityProvider)oldBarrel);
        if (owner2 == null) {
            return new ItemStack((ItemLike)BlockTieredPersonnalBarrel.getUpgrade(tier).m_5456_());
        }
        ItemStack stack = new ItemStack((ItemLike)BlockTieredPersonnalBarrel.getUpgrade(tier).m_5456_());
        stack.getCapability(Capabilities.OWNER_OBJECT).ifPresent(i -> i.setOwnerUUID(SecurityUtils.get().getOwnerUUID((ICapabilityProvider)oldBarrel)));
        TieredPersonalStorageManager.transferToNew(oldBarrel, stack);
        return stack;
    }

    public boolean m_8004_(int p_44314_, int p_44315_) {
        return p_44314_ * p_44315_ >= 9;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EMRecipeSerializers.PERSONAL_BARREL_UPGRADING.get();
    }
}

